<?php
$anchor = '';
if (!empty($block['anchor'])) {
    $anchor = 'id="' . esc_attr($block['anchor']) . '" ';
}

$class_name = 'juist-development-block';
if (!empty($block['className'])) {
    $class_name .= ' ' . $block['className'];
}
if (!empty($block['align'])) {
    $class_name .= ' align' . $block['align'];
}
if (get_field('no-margin-bottom')) {
    $class_name .= ' has-no-margin-bottom';
}

$title = get_field('dev_title') ?: 'Ontwikkeling';
$text = get_field('dev_text');
?>

<section class="<?php echo esc_attr($class_name); ?>">
    <div class="container">
        <div class="row g-0">
            <div class="col-12 col-lg-6">
                <div class="content">
                    <h2 id="ontwikkeling"><?= $title ?></h2>
                    <?= $text ?>
                </div>
            </div>
            <div class="col-12 col-lg-6">
                <?php if (have_rows('dev_rtcs')):
                    $i = 0; ?>
                    <div class="rtcs">
                        <?php while (have_rows('dev_rtcs')):
                            the_row();
                            $title = get_sub_field('dev_rtc_title');
                            $location = get_sub_field('dev_rtc_location');
                            $name = get_sub_field('dev_rtc_coordinator_name');
                            $email = get_sub_field('dev_rtc_coordinator_email');
                            $trainer_name = get_sub_field('dev_rtc_trainer_name');
                            $trainer_email = get_sub_field('dev_rtc_trainer_email');
                            ?>
                            <div class="accordion-item">
                                <div class="heading">
                                    <strong><?= $title ?></strong>
                                    <div class="icon-text title">
                                        <div class="icon"><i class="fa-solid fa-location-dot"></i></div>
                                        <div class="text"><i><?= $location ?></i></div>
                                    </div>
                                </div>
                                <div class="content">
                                    <p>
                                        <strong>Coördinator</strong>
                                        <?= $name ? $name . '<br>' : '' ?>
                                        <?= $email ? '<a href="mailto:' . $email . '">' . $email . '</a>' : '' ?>
                                    </p>
                                    <p>
                                        <strong>Hoofdtrainer</strong>
                                        <?= $trainer_name ? $trainer_name . '<br>' : '' ?>
                                        <?= $trainer_email ? '<a href="mailto:' . $trainer_email . '">' . $trainer_email . '</a>' : '' ?>
                                    </p>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>