import { __ } from '@wordpress/i18n';

(function ($) {
    $(document).ready(function () {
        /* Fixed sidebar navigation */

        $(".juist-side-nav-block .acf-innerblocks-container h2, .juist-side-nav-block .acf-innerblocks-container h3").each(function (i) {
            if (i === 0) {
                $("#page-nav-list").append('<li><a href="#' + $(this).attr('id') + '" class="current">' + $(this).text() + '</a></li>');
            } else {
                $("#page-nav-list").append('<li><a href="#' + $(this).attr('id') + '">' + $(this).text() + '</a></li>');
            }
        });

        let scrolling = false;

        $(window).scroll(function () {
            scrolling = true;
        });

        setInterval(() => {
            if (scrolling) {
                scrolling = false;

                var windowTop = Math.max($('body').scrollTop(), $('html').scrollTop());

                $('.juist-side-nav-block .acf-innerblocks-container h2, .juist-side-nav-block .acf-innerblocks-container h3').each(function (index) {

                    if (windowTop > ($(this).position().top - 500)) {
                        $('#page-nav-list li a.current').removeClass('current');
                        $('#page-nav-list li a:eq(' + index + ')').addClass('current');
                    }

                });

            }
        }, 200);

        var config = { attributes: true, childList: true, characterData: true };
        var observers = [];

        function setObserver(target, index) {

            var observer = new MutationObserver(function (mutations) {
                mutations.forEach(function (mutation) {
                    if ($(mutation.target).hasClass('current')) {
                        $('.juist-side-nav-block .page-nav').scrollLeft(
                            $('#page-nav-list li .current').offset().left - $('.juist-side-nav-block .page-nav').offset().left + $('.juist-side-nav-block .page-nav').scrollLeft() - 15
                        );
                    }
                });
            });

            observer.observe(target, config);
            observers.push({ [index]: observer });
        }

        $("#page-nav-list li a").each(function (index, el) {
            setObserver(el, index)
        });

        $('#page-nav-list li a').click(function (e) {

            var hrefString = $(this).attr('href'),
                hrefString = hrefString.replace(/^#/, ''),
                current = $('.juist-side-nav-block .page-nav').scrollLeft(),
                left = $(this).position().left;

            e.preventDefault();

            $('html,body').animate({
                scrollTop: $('#' + hrefString).offset().top - 300
            }, 500);

            $('.juist-side-nav-block .page-nav').animate({
                scrollLeft: current + left - 100
            }, 200);

        });
    });
})(jQuery, window);