<?php
$anchor = '';
if (!empty($block['anchor'])) {
    $anchor = 'id="' . esc_attr($block['anchor']) . '" ';
}

$class_name = 'juist-cards-block';
if (!empty($block['className'])) {
    $class_name .= ' ' . $block['className'];
}
if (!empty($block['align'])) {
    $class_name .= ' align' . $block['align'];
}

$image = get_field('image');
$title = get_field('title');
$description = get_field('description');
$link = get_field('link');

?>

<!-- Card -->
<div <?php echo $anchor; ?> class="<?php echo esc_attr($class_name); ?> <?php if(!$image): ?>no-image<?php endif; ?>">
    <a href="<?= $link; ?>" class="card-link">
        <?php if($image): ?>
            <div class="card-top">
                <?= wp_get_attachment_image($image, 'full card-img-top', false) ?>
            </div>
        <?php endif; ?>
        <div class="card-body">
            <h2 class="card-title"><?= $title; ?></h2>
            <p class="card-text"><?= $description; ?> </p>
            <div class="btn btn-primary">
                <i class="far fa-arrow-right"></i>
            </div>
        </div>
    </a>
</div>