<?php
if( isset( $block['data']['preview_image_help'] )  ) :
    echo '<img src="'. get_template_directory_uri() . '/template-blocks/' . $block['data']['preview_image_help'] .'" style="width:100%; height:auto;">';
else:

// Support custom "anchor" values.
$anchor = '';
if ( ! empty( $block['anchor'] ) ) {
    $anchor = 'id="' . esc_attr( $block['anchor'] ) . '" ';
}

// Load values and assign defaults.
$rand = rand();
$cols_view = get_field('faq_cols_view');
$per_page = get_field('faq_max_posts');
$per_page_responsive = get_field('faq_max_posts_responsive');
$posts = get_field('faq_posts');
$terms = get_field('faq_cat');
$questions_array = array();

// Create class attribute allowing for custom "className" and "align" values.
$class_name = 'wp-block-juist-faq';
if ( ! empty( $block['className'] ) ) {
    $class_name .= ' ' . $block['className'];
}
if ( ! empty( $block['align'] ) ) {
    $class_name .= ' align' . $block['align'];
}
if( $cols_view ) {
    $class_name .= ' cols-view';
}

// Check if neither terms nor posts are selected, then fetch all questions
if (empty($terms) && empty($posts)) {
    // Fetch all terms (categories) and their questions
    $all_terms = get_terms(array(
        'taxonomy' => 'subject', // Replace 'faq_category' with the actual taxonomy name for FAQ categories
        'hide_empty' => true,
    ));
    foreach ($all_terms as $term) {
        $questions = get_faq_questions(null, $term, $per_page);
        if ($questions) {
            $questions_array[$term->name] = [
                'slug' => sanitize_title($term->name),
                'questions' => $questions,
            ];
        }
    }
} elseif ($terms) {
    foreach ($terms as $term) {
        $questions = get_faq_questions($posts, $term, $per_page);
        if ($questions) {
            // Store questions in an array indexed by term name
            $questions_array[$term->name] = [
                'slug' => sanitize_title($term->name),
                'questions' => $questions,
            ];
        }
    }
} elseif ($posts) {
    // If no terms are selected, fetch questions based on selected posts
    $questions = get_faq_questions($posts, 0, $per_page);
    if ($questions) {
        $questions_array['FAQ'] = [
            'slug' => 'faq',
            'questions' => $questions,
        ];
    }
}

// Render the FAQ section if there are questions to display
if ($questions_array): ?>

<section <?= $anchor; ?> class="<?= esc_attr($class_name); ?>">
    <?php if (!empty($terms) && count($terms) > 1): ?>
        <!-- Render tabs for each term -->
        <div class="tabs">
            <?php $i = 0; ?>
            <?php foreach ($questions_array as $key => $value): ?>
                <div class="tab-item <?= $i == 0 ? 'active' : '' ?>" data-target="tab<?= $i ?>">
                    <?= $key ?>
                </div>
                <?php $i++; ?>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <!-- Render the content for each tab -->
    <?php $i = 0; ?>
    <?php foreach ($questions_array as $key => $value): ?>
        <div class="tab-content <?= $i == 0 ? 'active' : '' ?>" id="tab<?= $i ?>">
            <?php if ($value): ?>
                <?php $col_items = ceil(count($value['questions']) / 2); ?>
                <div class="accordion" id="accordion<?= $rand ?>">
                    <?php if ($cols_view): ?>
                        <div class="columns">
                            <div>
                    <?php endif; ?>

                    <!-- Loop through each question and display it -->
                    <?php $a = 1; ?>
                    <?php foreach ($value['questions'] as $question): ?>
                        <div class="accordion-item <?= $per_page_responsive != -1 && $per_page_responsive < $a ? 'hide' : '' ?>">
                            <h5 class="header"><?= $question['title'] ?></h5>
                            <div class="drop">
                                <div class="content">
                                    <?= $question['answer'] ?>
                                </div>
                            </div>
                        </div>
                        <?php if ($cols_view && $a % $col_items == 0 && $a < count($value['questions'])): ?>
                            </div><div>
                        <?php endif; ?>
                        <?php $a++; ?>
                    <?php endforeach; ?>

                    <?php if ($cols_view): ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <?php $i++; ?>
        </div>
    <?php endforeach; ?>
</section>

<?php endif; ?>
<?php endif; ?>