<?php
/* --- Register custom post types --- */

function juist_custom_posts_faq() {

    /* FAQ */
    $args = array(
        'label' => __('FAQ', 'juist'),
        'labels' => array(
            'add_new' => __('Nieuwe vraag', 'juist'),
            'add_new_item' => __('Vraag toevoegen', 'juist'),
            'edit_item' => __('Wijzig vraag', 'juist'),
            'not_found' => __('Geen vragen gevonden', 'juist'),
            'not_found_in_trash' => __('Geen vragen gevonden in de prullenbak', 'juist')
        ),
        'menu_icon' => 'dashicons-format-chat',
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_rest' => false,
        'capability_type' => 'post',
        'hierarchical' => false,
        'rewrite' => array('slug' => __('vraag', 'juist')),
        'query_var' => true,
        'has_archive' => false,
        'publicly_queryable' => false,
        'supports' => array('title', 'editor')
    );

    register_post_type('faq', $args);
}
add_action('init', 'juist_custom_posts_faq');

/* Customer service subjects */
register_taxonomy(
    'subject',
    'faq',
    array(
        'hierarchical'      => true,
        'show_ui'           => true,
        'show_in_rest'      => true,
        'show_admin_column' => true,
        'label' => __( 'Onderwerpen', 'juist' ),
    )
);