<?php
function get_faq_questions($posts, $term = null, $per_page = -1) {
    $questions = [];
    $args = [
        'post_type' => 'faq',
        'posts_per_page' => $per_page,
        'orderby' => 'title',
        'order' => 'ASC',
        'post__in' => $posts,
    ];
    
    // If a term is provided, add a taxonomy query to the arguments.
    if ($term !== null) {
        $args['tax_query'] = [
            [
                'taxonomy' => 'subject',
                'field' => 'term_id',
                'terms' => $term->term_id
            ]
        ];
    }

    $query = new WP_Query($args);
    while ($query->have_posts()) {
        $query->the_post();
        $questions[] = [
            'title' => get_the_title(),
            'answer' => get_the_content(),
        ];
    }
    wp_reset_postdata();

    return $questions;
}